
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  18-Mar-08 
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CERT_TLK_ATP_menu.c#1:csrc:1
   *  \author Sagitb
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


#include "DX_VOS_BaseTypes.h"
#include "MW_ATP_UTIL_funcs.h"
#include "DX_VOS_Stdio.h"
#include "tlk_cert_version.h"
#include "CERT_TLK_ATP_tests.h"
#include "CERT_TLK_ATP_util.h"
#ifndef TLK_CERT_NO_SCLK
#include "tlk_sclk_api_version.h"
#endif

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_CERT_Acceptance_ALL_TESTS      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function runs all the tests
*  
******************************************************************************/
DxError_t TST_ATP_TLK_CERT_Acceptance_ALL_TESTS( void )
{
  /********* TST Variables Definitions ************/
  DxError_t          TST_Status = DX_SUCCESS, TST_TempError = DX_SUCCESS;

  ATP_LOG_TST_PRINT((MW_ATP_MSG,"******************************************************* \n"));
  ATP_LOG_TST_PRINT((MW_ATP_MSG,"************** Run All ATP tests ********************** \n"));
  ATP_LOG_TST_PRINT((MW_ATP_MSG,"******************************************************* \n \n"));

  TST_Status = TST_ATP_TLK_CERT_CertificateIdCompute();
  TST_TempError = TST_TempError + TST_Status;

  TST_Status = TST_ATP_TLK_CERT_CertificateParamGet();
  TST_TempError = TST_TempError + TST_Status;

  TST_Status = TST_ATP_TLK_CERT_CertificateChainValidation();
  TST_TempError = TST_TempError + TST_Status;

  TST_Status = TST_ATP_TLK_CERT_NonceIssuance();
  TST_TempError = TST_TempError + TST_Status;

  TST_Status = TST_ATP_TLK_CERT_ResponseProcess();
  TST_TempError = TST_TempError + TST_Status;

  TST_Status = TST_ATP_TLK_CERT_CertFromResponseExtract();
  TST_TempError = TST_TempError + TST_Status;



  /*Check if all tests pass*/
  if (TST_TempError != TST_PASS )
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!! ONE OR MORE OF THE ATP TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
  }
  else
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n \n**********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"**********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"*** ALL OF THE TLK CERT ATP  TESTS PASS     :-)         *****\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"**********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"**********************\n"));
  }
  return TST_TempError;
}
/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_CERT_Run_All_Tests      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function init ,runs all the CERT Acceptance tests and terminates.
*  
******************************************************************************/
DxError_t TST_ATP_TLK_CERT_Run_All_Tests( void )
{
  /********* TST Variables Definitions ************/
  DxError_t         TST_Status = DX_SUCCESS, TST_TempError = DX_SUCCESS;

  #ifndef TLK_CERT_NO_SCLK
  TST_Status = TST_ATP_TLK_CERT_INIT();
  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_SCLK_TST_Init_Tests","","");

  #endif

  TST_Status = TST_ATP_TLK_CERT_Acceptance_ALL_TESTS();
  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_ATP_TLK_SCLK_Acceptance_ALL_TESTS","","");

  #ifndef TLK_CERT_NO_SCLK
  TST_Status = TST_ATP_TLK_CERT_Terminate();
  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_SCLK_TST_Terminate","","");
  #endif
  return TST_PASS;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }

}
 /*****************************************************************************
* Function Name:                                                           
*  ODRM_TLK_ATP_menu      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function runs the ATP menu
*  
******************************************************************************/

 DxError_t CERT_TLK_ATP_menu (void)
 {

   DxInt_t                 Var;
   DxError_t               TST_Status;
   TLK_CERT_Version_t      TST_Version;
#ifndef TLK_CERT_NO_SCLK
   TLK_SCLK_Version_t      TST_SCLK_Version;
   TST_Status =            TLK_SCLK_VersionGet(&TST_SCLK_Version);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_SCLK_VersionGet", "!!!!!!!!!", "!!!!!!!!!");

   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----------------------------------------------"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----[Secured Time Clock Toolkit Version]----"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----------------------------------------------"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n             %s %c.%d.%d.%d                   ",
   TST_SCLK_Version.tlk_sclk.componentName,
   TST_SCLK_Version.tlk_sclk.typeVer,
   TST_SCLK_Version.tlk_sclk.majorVer,
   TST_SCLK_Version.tlk_sclk.minorVer,
   TST_SCLK_Version.tlk_sclk.subVer));
   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----------------------------------------------\n"));

   TST_Status = TST_ATP_TLK_CERT_INIT();


   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_ATP_TLK_CERT_INIT", "!!!!!!!!!", "!!!!!!!!!");

   MW_ATP_RETURN_ON_FAILURE(TST_Status);
#endif

   TST_Status =TLK_CERT_VersionGet(&TST_Version);

   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_CERT_VersionGet", "!!!!!!!!!", "!!!!!!!!!");

   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----------------------------------------------"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----[Certificate handling toolkit Version]----"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----------------------------------------------"));
   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n             %s %c.%d.%d.%d                   ",
                     TST_Version.tlk_cert.componentName,
                     TST_Version.tlk_cert.typeVer,
                     TST_Version.tlk_cert.majorVer,
                     TST_Version.tlk_cert.minorVer,
                     TST_Version.tlk_cert.subVer));
   ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----------------------------------------------"));


   for(;;)
   {
     
     for(;;)
     {
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n\n              -- DISCRETIX LTD 2008 --          "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n -- Certificate handling toolkit Acceptance tests --"));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n----------------------------------------------------"));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-------------[ Main Tests Menu ]--------------------"));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n----------------------------------------------------"));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [1] - Certificate identifier generation test  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [2] - Certificate parameters retrieval test "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [3] - Certificate chain Validation test  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [4] - Nonce Issuance test  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [5] - OCSP Response Process test  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [6] - Extract Certificate from Response test  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [T] - Run All Tetsts  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [Z] - End Of Tests  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n"));

       GET_NON_WHITE_SPACE_CHAR(Var);

       DX_VOS_Printf("\n Test = %c\n",Var);

       if (Var<='z')
         break;
        else
         DX_VOS_Printf("\n Error[%d]  Please select '1'-'XX'\n\n",Var);
      }
      
      switch(Var)
      {
        case '1':
         TST_ATP_TLK_CERT_CertificateIdCompute();
          break;
        case '2':
          TST_ATP_TLK_CERT_CertificateParamGet();
          break;
        case '3':
          TST_ATP_TLK_CERT_CertificateChainValidation();
          break;
        case '4':
          TST_ATP_TLK_CERT_NonceIssuance();
          break;
        case '5':
          TST_ATP_TLK_CERT_ResponseProcess();
          break;
        case '6':
          TST_ATP_TLK_CERT_CertFromResponseExtract();
          break;
       case 'T':
          TST_ATP_TLK_CERT_Acceptance_ALL_TESTS();
         break;
       }

       if(Var =='Z')
         break;
     }

   #ifndef TLK_CERT_NO_SCLK
    /* Terminate the Secure clock  toolkit */
    TST_ATP_TLK_CERT_Terminate();
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_ATP_TLK_CERT_Terminate", "!!!!!!!!!", "!!!!!!!!!");
    MW_ATP_RETURN_ON_FAILURE(TST_Status);
#endif

  return 0;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}



